//
//  MCReportLayout.h
//  Composer
//
//  Created by Alykhan Jetha on 01/08/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import "MCReportRegion.h"

@class MCReportLayoutPage;
@class MCReportDocument;
@class MCReportLayoutOverlay;

@interface MCReportLayout : MCReportRegion {
	id (selectedRegion);
	int drawsDebugLines;
	
	MCReportDocument *reportDocument;  // weak ref
	
	BOOL snapsToGrid;
	float gridSize;
	
	MCReportLayoutOverlay *overlay; // weak ref
	
	MCReportRegion *currentDragDestination;
}

@property (retain) MCReportRegion *currentDragDestination;

-(IBAction)cycleDebugLines:(id)sender;

- (void)setReportDocument:(MCReportDocument *)aDoc;
- (MCReportDocument *)reportDocument;

- (IBAction)addMasterPage:(id)sender;
- (IBAction)removeMasterPage:(id)sender;

- (NSArray *)masterPages;

- (void)pageWidthWillChangeBy:(float)aDiff;

- (MCReportLayoutPage *)currentPage;

- (BOOL)layoutSnapsToGrid;
- (float)layoutGridSpacing;

- (BOOL)snapsToGrid;
- (void)setSnapsToGrid:(BOOL)flag;

- (float)gridSize;
- (void)setGridSize:(float)aGridSize;

- (int)drawsDebugLines;
- (void)setDrawsDebugLines:(int)val;

- (id)selectedRegion;
- (void)setSelectedRegion:(id)aSelectedRegion;

/*!
 Returns the selectedView if there is exactly one, nil otherwise.
 */
- (id)selectedView;


- (MCReportElement *)reportElementForEvent:(NSEvent *)event;
- (void)updateSelectionRects;

- (void)changeFont:(id)sender;

- (void)region:(id)region didChangeSelection:(id)selection;
- (void)region:(id)region didChangeSelection:(id)selection changeFirstResponder:(BOOL)responder;



/*!
 These are first responder covers to ReportRegion method for better control over menu validation and actions
 */

- (IBAction)layoutInsertBox:(id)sender;
- (IBAction)layoutInsertTextArea:(id)sender;
- (IBAction)layoutInsertDynamicTextArea:(id)sender;
- (IBAction)layoutInsertTable:(id)sender;
- (IBAction)layoutInsertImage:(id)sender;
- (IBAction)layoutInsertVerticalLine:(id)sender;
- (IBAction)layoutInsertHorizontalLine:(id)sender;
- (IBAction)layoutInsertStrip:(id)sender;
- (IBAction)layoutInsertCheckmark:(id)sender;
- (IBAction)layoutInsertColorBlob:(id)sender;
- (IBAction)layoutAddColumns:(id)sender;
- (IBAction)layoutAddColumnToLeft:(id)sender;
- (IBAction)layoutAddColumnToRight:(id)sender;
- (IBAction)layoutInsertPageNumberArea:(id)sender;
- (IBAction)layoutChangeSelectedElementsToTextArea:(id)sender;
- (IBAction)layoutChangeSelectedElementsToBox:(id)sender;
- (IBAction)layoutChangeSelectedElementsToImage:(id)sender;
- (IBAction)layoutChangeSelectedElementsToCheckmark:(id)sender;
- (IBAction)layoutChangeSelectedElementsToColorBlob:(id)sender;
- (IBAction)layoutAlignLeftEdges:(id)sender;
- (IBAction)layoutAlignRightEdges:(id)sender;
- (IBAction)layoutAlignTopEdges:(id)sender;
- (IBAction)layoutAlignBottomEdges:(id)sender;
- (IBAction)layoutPushElementBackwards:(id)sender;
- (IBAction)layoutPullElementForward:(id)sender;
- (IBAction)layoutMatchHeights:(id)sender;
- (IBAction)layoutMatchWidths:(id)sender;
- (IBAction)layoutSizeToFit:(id)sender;


@end
